/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion.compat;

import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ench.compat.EnchantingCategory;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.potion.PotionCharmItem;
import shadows.apotheosis.potion.PotionCharmRecipe;
import shadows.apotheosis.potion.PotionEnchantingRecipe;

@JeiPlugin
public class PotionJEIPlugin
implements IModPlugin {
    ICraftingGridHelper gridHelper;

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        this.gridHelper = reg.getJeiHelpers().getGuiHelper().createCraftingGridHelper(1);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.getCraftingCategory().addCategoryExtension(PotionCharmRecipe.class, x$0 -> new PotionCharmRecipeWrapper((PotionCharmRecipe)((Object)x$0)));
        EnchantingCategory.registerExtension(PotionEnchantingRecipe.class, new PotionCharmEnchantingWrapper());
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        if (!Apotheosis.enablePotion) {
            return;
        }
        reg.registerSubtypeInterpreter((Item)Apoth.Items.POTION_CHARM, (IIngredientSubtypeInterpreter)new PotionCharmSubtypes());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "potion");
    }

    private class PotionCharmEnchantingWrapper
    implements EnchantingCategory.Extension<PotionEnchantingRecipe> {
        private PotionCharmEnchantingWrapper() {
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, IRecipeSlotBuilder input, IRecipeSlotBuilder output, EnchantingRecipe recipe, IFocusGroup focuses) {
            Potion potion = PotionUtils.m_43579_((ItemStack)focuses.getFocuses(VanillaTypes.ITEM).findFirst().map(IFocus::getTypedValue).map(ITypedIngredient::getIngredient).orElse(ItemStack.f_41583_));
            if (potion != Potions.f_43598_) {
                ItemStack out = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
                PotionUtils.m_43549_((ItemStack)out, (Potion)potion);
                ItemStack in = out.m_41777_();
                out.m_41784_().m_128379_("Unbreakable", true);
                input.addIngredient(VanillaTypes.ITEM, (Object)in);
                output.addIngredient(VanillaTypes.ITEM, (Object)out);
            } else {
                ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
                ArrayList<ItemStack> unbreakable = new ArrayList<ItemStack>();
                for (Potion p : ForgeRegistries.POTIONS) {
                    if (p.m_43488_().size() != 1 || ((MobEffectInstance)p.m_43488_().get(0)).m_19544_().m_8093_()) continue;
                    ItemStack charm = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
                    PotionUtils.m_43549_((ItemStack)charm, (Potion)p);
                    potionStacks.add(charm);
                    ItemStack copy = charm.m_41777_();
                    copy.m_41784_().m_128379_("Unbreakable", true);
                    unbreakable.add(copy);
                }
                input.addIngredients(VanillaTypes.ITEM, potionStacks);
                output.addIngredients(VanillaTypes.ITEM, unbreakable);
            }
            builder.createFocusLink(new IRecipeSlotBuilder[]{input, output});
        }
    }

    private class PotionCharmSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private PotionCharmSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            if (context != UidContext.Recipe) {
                if (!PotionCharmItem.hasPotion(stack)) {
                    return "";
                }
                Potion p = PotionUtils.m_43579_((ItemStack)stack);
                MobEffectInstance contained = (MobEffectInstance)p.m_43488_().get(0);
                return contained.m_19544_().getRegistryName() + "@" + contained.m_19564_() + "@" + contained.m_19557_();
            }
            return "";
        }
    }

    private class PotionCharmRecipeWrapper
    implements ICraftingCategoryExtension {
        private final PotionCharmRecipe recipe;

        PotionCharmRecipeWrapper(PotionCharmRecipe recipe) {
            this.recipe = recipe;
        }

        public ResourceLocation getRegistryName() {
            return this.recipe.m_6423_();
        }

        public Size2i getSize() {
            return new Size2i(3, 3);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
            Potion potion = PotionUtils.m_43579_((ItemStack)focuses.getFocuses(VanillaTypes.ITEM).findFirst().map(IFocus::getTypedValue).map(ITypedIngredient::getIngredient).orElse(ItemStack.f_41583_));
            List recipeInputs = this.recipe.m_7527_().stream().map(i -> Arrays.asList(i.m_43908_())).collect(Collectors.toCollection(ArrayList::new));
            if (potion != Potions.f_43598_) {
                IntListIterator intListIterator = this.recipe.getPotionSlots().iterator();
                while (intListIterator.hasNext()) {
                    int i2 = (Integer)intListIterator.next();
                    recipeInputs.set(i2, Arrays.asList(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion)));
                }
            }
            ItemStack output = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
            PotionUtils.m_43549_((ItemStack)output, (Potion)potion);
            Size2i size = this.getSize();
            craftingGridHelper.setInputs(builder, VanillaTypes.ITEM, recipeInputs, size.width, size.height);
            if (potion != Potions.f_43598_) {
                craftingGridHelper.setOutputs(builder, VanillaTypes.ITEM, Arrays.asList(output));
            } else {
                ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
                for (Potion p : ForgeRegistries.POTIONS) {
                    if (p.m_43488_().size() != 1 || ((MobEffectInstance)p.m_43488_().get(0)).m_19544_().m_8093_()) continue;
                    ItemStack charm = new ItemStack((ItemLike)Apoth.Items.POTION_CHARM);
                    PotionUtils.m_43549_((ItemStack)charm, (Potion)p);
                    potionStacks.add(charm);
                }
                craftingGridHelper.setOutputs(builder, VanillaTypes.ITEM, potionStacks);
            }
        }
    }
}

